/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.client.event;

import com.mojang.blaze3d.shaders.Uniform;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.momosoftworks.coldsweat.api.event.vanilla.RenderLevelEvent;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.client.gui.Overlays;
import com.momosoftworks.coldsweat.client.renderer.PostProcessShaderManager;
import com.momosoftworks.coldsweat.common.capability.handler.EntityTempManager;
import com.momosoftworks.coldsweat.common.event.TempEffectsCommon;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.registries.ModEffects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class TempEffectsClient {
    static float BLEND_TEMP = 0.0f;
    static float PREV_X_SWAY = 0.0f;
    static float PREV_Y_SWAY = 0.0f;
    static float X_SWAY_SPEED = 0.0f;
    static float Y_SWAY_SPEED = 0.0f;
    static float X_SWAY_PHASE = 0.0f;
    static float Y_SWAY_PHASE = 0.0f;
    static float TIME_SINCE_NEW_SWAY = 0.0f;
    static int COLD_IMMUNITY = 0;
    static int HOT_IMMUNITY = 0;
    static ResourceLocation HAZE_TEXTURE = new ResourceLocation("cold_sweat", "textures/gui/overlay/haze.png");
    static final ResourceLocation FREEZE_TEXTURE = new ResourceLocation("textures/misc/powder_snow_outline.png");

    @SubscribeEvent
    public static void setCamera(ViewportEvent.ComputeCameraAngles event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null || EntityTempManager.immuneToTempEffects((LivingEntity)player)) {
            return;
        }
        if (!Minecraft.m_91087_().m_91104_()) {
            float frameTime = Minecraft.m_91087_().m_91297_();
            float temp = (float)Temperature.get((LivingEntity)player, Temperature.Trait.BODY);
            BLEND_TEMP += (temp - BLEND_TEMP) * frameTime / 20.0f;
            if (ConfigSettings.DISTORTION_EFFECTS.get().booleanValue()) {
                if (BLEND_TEMP <= -50.0f && COLD_IMMUNITY < 4) {
                    double tickTime = (double)player.f_19797_ + event.getPartialTick();
                    float shiverIntensity = CSMath.blend(((float)Math.sin(tickTime / 10.0) + 1.0f) * 0.03f + 0.01f, 0.0f, BLEND_TEMP, -100.0f, -50.0f);
                    float shiverRotation = (float)(Math.sin(tickTime * 2.5) * (double)(shiverIntensity *= Minecraft.m_91087_().m_91297_() * 10.0f)) / (float)(1 + COLD_IMMUNITY);
                    player.m_146922_(player.m_146908_() + shiverRotation);
                } else if (BLEND_TEMP >= 50.0f && HOT_IMMUNITY < 4) {
                    float immunityModifier = CSMath.blend(BLEND_TEMP, 50.0f, HOT_IMMUNITY, 0.0f, 4.0f);
                    float factor = CSMath.blend(0.0f, 20.0f, immunityModifier, 50.0f, 100.0f);
                    if (TIME_SINCE_NEW_SWAY > 100.0f || X_SWAY_SPEED == 0.0f || Y_SWAY_SPEED == 0.0f) {
                        TIME_SINCE_NEW_SWAY = 0.0f;
                        X_SWAY_SPEED = (float)(Math.random() * (double)0.005f + (double)0.005f);
                        Y_SWAY_SPEED = (float)(Math.random() * (double)0.005f + (double)0.005f);
                    }
                    TIME_SINCE_NEW_SWAY += frameTime;
                    X_SWAY_PHASE = (float)((double)X_SWAY_PHASE + Math.PI * 2 * (double)frameTime * (double)X_SWAY_SPEED);
                    Y_SWAY_PHASE = (float)((double)Y_SWAY_PHASE + Math.PI * 2 * (double)frameTime * (double)Y_SWAY_SPEED);
                    float xOffs = (float)(Math.sin(X_SWAY_PHASE) * (double)factor);
                    float yOffs = (float)(Math.sin(Y_SWAY_PHASE) * (double)factor * 2.0);
                    player.m_146926_(player.m_146909_() + xOffs - PREV_X_SWAY);
                    player.m_146922_(player.m_146908_() + yOffs - PREV_Y_SWAY);
                    PREV_X_SWAY = xOffs;
                    PREV_Y_SWAY = yOffs;
                }
            }
        }
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player == null || EntityTempManager.immuneToTempEffects((LivingEntity)player)) {
                return;
            }
            if (player.f_19797_ % 5 == 0) {
                boolean hasGrace = player.m_21023_(ModEffects.GRACE);
                COLD_IMMUNITY = player.m_21023_(ModEffects.ICE_RESISTANCE) || hasGrace ? 4 : 0;
                HOT_IMMUNITY = player.m_21023_(MobEffects.f_19607_) || hasGrace ? 4 : 0;
                if (COLD_IMMUNITY != 4) {
                    COLD_IMMUNITY = TempEffectsCommon.getColdResistance((Player)player);
                }
                if (HOT_IMMUNITY != 4) {
                    HOT_IMMUNITY = TempEffectsCommon.getHeatResistance((Player)player);
                }
            }
        }
    }

    @SubscribeEvent
    public static void renderFog(ViewportEvent event) {
        if (!(event instanceof ViewportEvent.RenderFog) && !(event instanceof ViewportEvent.ComputeFogColor)) {
            return;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null || EntityTempManager.immuneToTempEffects((LivingEntity)player)) {
            return;
        }
        double fogDistance = ConfigSettings.HEATSTROKE_FOG_DISTANCE.get();
        if (fogDistance >= 64.0) {
            return;
        }
        if (fogDistance < Double.POSITIVE_INFINITY && BLEND_TEMP >= 50.0f && HOT_IMMUNITY < 4) {
            float tempWithResistance = CSMath.blend(BLEND_TEMP, 50.0f, HOT_IMMUNITY, 0.0f, 4.0f);
            if (event instanceof ViewportEvent.RenderFog) {
                ViewportEvent.RenderFog fog = (ViewportEvent.RenderFog)event;
                if (fogDistance > (double)fog.getFarPlaneDistance()) {
                    return;
                }
                fog.setFarPlaneDistance(CSMath.blend(fog.getFarPlaneDistance(), (float)fogDistance, tempWithResistance, 50.0f, 90.0f));
                fog.setNearPlaneDistance(CSMath.blend(fog.getNearPlaneDistance(), (float)(fogDistance * 0.3), tempWithResistance, 50.0f, 90.0f));
                fog.setCanceled(true);
            } else {
                ViewportEvent.ComputeFogColor fogColor = (ViewportEvent.ComputeFogColor)event;
                fogColor.setRed(CSMath.blend(fogColor.getRed(), 0.01f, tempWithResistance, 50.0f, 90.0f));
                fogColor.setGreen(CSMath.blend(fogColor.getGreen(), 0.01f, tempWithResistance, 50.0f, 90.0f));
                fogColor.setBlue(CSMath.blend(fogColor.getBlue(), 0.05f, tempWithResistance, 50.0f, 90.0f));
            }
        }
    }

    @SubscribeEvent
    public static void vignette(RenderGuiOverlayEvent.Pre event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null || EntityTempManager.immuneToTempEffects((LivingEntity)player)) {
            return;
        }
        if (event.getOverlay() == VanillaGuiOverlay.VIGNETTE.type() && (BLEND_TEMP > 0.0f && HOT_IMMUNITY < 4 || BLEND_TEMP < 0.0f && COLD_IMMUNITY < 4)) {
            float resistance = CSMath.blend(1.0f, 0.0f, BLEND_TEMP > 0.0f ? (float)HOT_IMMUNITY : (float)COLD_IMMUNITY, 0.0f, 4.0f);
            float opacity = CSMath.blend(0.0f, 1.0f, Math.abs(BLEND_TEMP), 50.0f, 100.0f) * resistance;
            float tickTime = (float)player.f_19797_ + event.getPartialTick();
            if (opacity == 0.0f) {
                return;
            }
            double width = event.getWindow().m_85441_();
            double height = event.getWindow().m_85442_();
            double scale = event.getWindow().m_85449_();
            RenderSystem.m_69465_();
            RenderSystem.m_69458_((boolean)false);
            RenderSystem.m_69478_();
            RenderSystem.m_69453_();
            if (BLEND_TEMP > 0.0f) {
                float vignetteBrightness = opacity + ((float)Math.sin((double)(tickTime + 3.0f) / 3.18306181683261) / 5.0f - 0.2f) * opacity;
                RenderSystem.m_157429_((float)0.231f, (float)0.0f, (float)0.0f, (float)vignetteBrightness);
                RenderSystem.m_157456_((int)0, (ResourceLocation)HAZE_TEXTURE);
            } else {
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)opacity);
                RenderSystem.m_157456_((int)0, (ResourceLocation)FREEZE_TEXTURE);
            }
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            Tesselator tesselator = Tesselator.m_85913_();
            BufferBuilder bufferbuilder = tesselator.m_85915_();
            bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
            bufferbuilder.m_5483_(0.0, height / scale, -90.0).m_7421_(0.0f, 1.0f).m_5752_();
            bufferbuilder.m_5483_(width / scale, height / scale, -90.0).m_7421_(1.0f, 1.0f).m_5752_();
            bufferbuilder.m_5483_(width / scale, 0.0, -90.0).m_7421_(1.0f, 0.0f).m_5752_();
            bufferbuilder.m_5483_(0.0, 0.0, -90.0).m_7421_(0.0f, 0.0f).m_5752_();
            tesselator.m_85914_();
            RenderSystem.m_69458_((boolean)true);
            RenderSystem.m_69482_();
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_69453_();
        }
    }

    @SubscribeEvent
    public static void onRenderBlur(RenderLevelEvent.Post event) {
        Minecraft mc = Minecraft.m_91087_();
        PostProcessShaderManager shaderManager = PostProcessShaderManager.getInstance();
        float playerTemp = (float)Overlays.BODY_TEMP;
        if (ConfigSettings.DISTORTION_EFFECTS.get().booleanValue() && playerTemp >= 50.0f && HOT_IMMUNITY < 4 && mc.f_91074_ != null && !EntityTempManager.immuneToTempEffects((LivingEntity)mc.f_91074_)) {
            Uniform blurRadius;
            float blur = CSMath.blend(0.0f, 7.0f, playerTemp, 50.0f, 100.0f) / (float)(HOT_IMMUNITY + 1);
            if (!shaderManager.hasEffect("heat_blur")) {
                shaderManager.loadEffect("heat_blur", PostProcessShaderManager.BLOBS);
            }
            if ((blurRadius = shaderManager.getPostPasses("heat_blur").get(0).m_110074_().m_108952_("Radius")) != null) {
                blurRadius.m_5985_(blur);
            }
        } else if (shaderManager.hasEffect("heat_blur")) {
            shaderManager.closeEffect("heat_blur");
        }
        shaderManager.process(event.getPartialTick());
    }
}

